<!-- Title: Design Sprint -->

This template outlines a sample set-up process, activities and deliverables for running a Remote Design Sprint. The specific activities and deliverables should be customized based on your objectives and timeline. 

Please refer to the [Remote Design Sprint Handbook page](https://about.gitlab.com/handbook/product/ux/design-sprint/) for additional recommendations.

## Design Sprint Focus
* [ ] Have you [determined that a Design Sprint is appropriate for this project](https://about.gitlab.com/handbook/product/ux/design-sprint/#when-to-opt-for-a-remote-design-sprint)?
_What is the focus of the [Design Sprint](https://about.gitlab.com/handbook/product/product-processes/#remote-design-sprint)? What problem area will you be solving for and who is the target user?_

## Objectives
_What is the objective(s) this Design Sprint will entail?_
<!-- Try to describe the objectives of the Sprint in detail. e.g., "We want to introduce a new feature but we are unsure that we are thinking about the solution from the customer's perspective, and through the Sprint we want to rethink the solution, prototype it and validate it with our customers" or "We are unhappy with the direction of one of our categories and we want to explore new directions with different stakeholders, reach to one solution and test it with users" or "Among the team we have different visions for a specific category and we want to work towards a solution we all support and test it with users".  --> 

## Outputs
_Select which outputs you want to have at the end of the Sprint._
- [ ] A User testing flow.
- [ ] A Prototype to be tested with users.
- [ ] User testing analysis. 
- [ ] (If the solution is viable) An epic or issue that describes the direction in details and the next steps
- [ ] Necessary updates to the Handbook.

## Design Sprint Details

| Start | End |
| ------ | ------ |
| YYYY-MM-DD | YYYY-MM-DD |
| TT:TT PST | TT:TT PST |

**Reference time zone:** All times will be posted in [UTC](https://www.timeanddate.com/worldclock/timezone/utc). 

### WHERE

**Zoom link:**

### WHO

   - `Name` `gitlab handle` - Facilitator 
   - `Name` `gitlab handle` - Decider (usually the Product Manager)
   - `Name` `gitlab handle` - Co-decider (optional)
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Sprint team member
   - `Name` `gitlab handle` - Co-facilitator (optional)

## Tools
Here is the list of tools for the Sprint preparation, collaboration and documentation. Prior to the Sprint make sure you have access to all of the following:

*  **GitLab**<br/>
Each Sprint day outcomes and material will be documented in separate issues under the Design Sprint epic: 
    * **Kickoff:** (Kickoff Issue Link)
    * **Day One:** (Day 1 Issue Link)
    * **Day Two:** (Day 2 Issue Link)
    * **Day Three:** (Day 3 Issue Link)
    * **Day Four:** (Day 4 Issue Link)

* **Mural** (You can join as anonymous but we need to be able to identify input against names, so please create an account beforehand.)<br/>
We will use Mural for most of the Sprint collaboration. Some of the things we will do in Mural: 
    * Create artifacts like affinity diagrams from participants' input.
    * Use post-its to comment on each other's points and to add notes.
    * Vote on ideas and solutions.
    * Create the first draft of the prototype.
    * **The Mural link can be found here:** (Mural Link)

* **Video and/or screen recording tool** (Loom, Quicktime, Zoom or another tool you are using).<br/>
As part of the pre-Sprint homework, you will be asked to record a short Lightning Walkthrough video (don't worry, this will be explained in detail during the Sprint :smile:). You can use any tool you feel comfortable with as long as it can capture your screen, mouse pointer, and audio.

* **A4/Letter-sized paper (preferably white, blank), Sharpies/Pens** (Please don't use a pencil because it doesn't create enough contrast for photos).<br/>
Day 2 of the Sprint involves some (async) ideation via sketching so you will need a writing utensil (Sharpies are preferred because they force you to draw at a lower fidelity because the small details aren't necessary at this point) and some paper. This is the most fun part of the Sprint where you get into a design thinking mindset and can appeal to your creative self. Don't worry, it's not about artistry, it's about ideas and collaboration. It'll be fun!

* **Camera (phone or other) or scanner**<br/>
You will need to upload sketches as images for the facilitator to prepare the material before the next sync meeting. You can take a photo with your phone or use a scanner if available.

* **Post-it notes (Optional)**<br/>
If you enjoy taking notes using Post-it notes make sure you have some of them as well. The upside is that they will make you feel more like you are in a workshop and will help the ideas flow (I find that typing is distracting while ideating). The downside is that you will have to digitize the ones you want to share with the team in Mural.

## Artefacts & Pre-Read Material

<!-- If there is material that will be useful for the participants to read before the Design Sprint add here, such as the sprint slide deck or design sprint material -->

### Handbook pages
<!-- Add a link to the category vision from the handbook -->

### Competitor resources
<!-- Add any solutions by competitors that are relevant to the Design Sprint topic and could be used as a source of inspiration. -->

### Articles on Design Sprints
  * [The Design Sprint](https://www.gv.com/sprint/)
  * [The Ultimate Guide To Remote Design Sprints](https://drive.google.com/file/d/16bwrAqHVf8qxovd87Q7LdzqwAgy7a6Rx/view?usp=sharing)

## Personas

Deciding which persona we are focusing on will be part of the Day 1 discussions in the workshop. The personas we are going to consider are:

<!-- Choose which personas could be target users, and choose from this list during the Sprint. Personas are described at https://handbook.gitlab.com/handbook/product/personas/

* [Parker (Product Manager)](https://handbook.gitlab.com/handbook/product/personas/#parker-product-manager)
* [Delaney (Development Team Lead)](https://handbook.gitlab.com/handbook/product/personas/#delaney-development-team-lead)
* [Presley (Product Designer)](https://handbook.gitlab.com/handbook/product/personas/#presley-product-designer)
* [Sasha (Software Developer)](https://handbook.gitlab.com/handbook/product/personas/#sasha-software-developer)
* [Priyanka (Platform Engineer)](https://handbook.gitlab.com/handbook/product/personas/#priyanka-platform-engineer)
* [Sidney (Systems Administrator)](https://handbook.gitlab.com/handbook/product/personas/#sidney-systems-administrator)
* [Rachel (Release Manager)](https://handbook.gitlab.com/handbook/product/personas/#rachel-release-manager)
* [Simone (Software Engineer in Test)](https://handbook.gitlab.com/handbook/product/personas/#simone-software-engineer-in-test)
* [Allison (Application Ops)](https://handbook.gitlab.com/handbook/product/personas/#allison-application-ops)
* [Ingrid (Infrastructure Operator)](https://handbook.gitlab.com/handbook/product/personas/#ingrid-infrastructure-operator)
* [Dakota (Application Development Director)](https://handbook.gitlab.com/handbook/product/personas/#dakota-application-development-director)
* [Dana (Data Analyst)](https://handbook.gitlab.com/handbook/product/personas/#dana-data-analyst)
* [Eddie (Content Editor)](https://handbook.gitlab.com/handbook/product/personas/#eddie-content-editor)
* [Amy (Application Security Engineer)](https://handbook.gitlab.com/handbook/product/personas/#amy-application-security-engineer)
* [Isaac (Infrastructure Engineer)](https://handbook.gitlab.com/handbook/product/personas/#isaac-infrastructure-security-engineer)
* [Alex (Security Operations Engineer)](https://handbook.gitlab.com/handbook/product/personas/#alex-security-operations-engineer)
* [Cameron (Compliance Manager)](https://handbook.gitlab.com/handbook/product/personas/#cameron-compliance-manager)

-->

## Pre-Sprint Preparation | Due Date: `Add Date`

- [ ] Promote this issue to an epic.
- [ ] Finalize objective and outputs. 
- [ ] Finalize participant list.
- [ ] Create a dedicated Slack channel and add participants.
- [ ] Create issues for each day of the sprint.
- [ ] Prepare activity slide deck.
- [ ] Prepare Mural Board and ensure participant access.
- [ ] Prepare instructional videos for activities (Lightning Talks, HMWs, Crazy 8s etc).
- [ ] Organize and inform team members who will be providing lightning talk recordings. 
- [ ] Open a recruitment issue for user testing.
- [ ] Create sync meetings in calendars for all participants.
- [ ] Record Kickoff Video. 
- [ ] Do a Sprint test run. 

## Sprint Kickoff | `Add Date`

#### Pre-Day Facilitator Checklist:
- [ ] Ensure [Kickoff Issue](Add Link) is complete. 
- [ ] Assign participants to the [Kickoff Issue](Add Link). 
- [ ] Ensure warm-up exercise Mural is set up. 
- [ ] Prep Q&A issue thread. 
- [ ] Send a `Welcome to the Sprint` slack message.

 |  Activity  | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---|
| Introduction to Design Sprints | Async | 20 Minutes | Video Recording | • The facilitator gives an overview of the Sprint, including details about what they are, why they are used, and why they can help solve the problem for this Sprint.  <br/> • The facilitator gives participants an overview of what they need to complete a Design Sprint such as a run down of the rules, and supples, as well as an agenda and basic expectations.  <br/> • The facilitator gives participants an overview of the problem we will be solving and allows for an async Q&A period. |
|  Icebreaker | Async |  5 Minutes | Mural  |  • All Sprint participants give an async introduction in Mural.  |
|  Q&A Period | Async |  5 Minutes | GitLab and Slack |  • Participants can ask questions about the Sprint. (Optional)  |
|  Record Lightning Talk | Async |  10 Minutes | Zoom |  • Participants record their Lightning Talk.  |

#### Post-Day Facilitator Checklist:
- [ ] Answer any questions that come up during the Q&A period. 
- [ ] Send a homework reminder in the Slack channel. 

## Day 1 - Sprint Homework | `Add Date`

#### Pre-Day Facilitator Checklist:
- [ ] Ensure [Day 1 Issue](Add Link) is complete.
- [ ] Ensure Lightning Talk recordings are added to the [Day 1 Issue](Add Link). 
- [ ] Ensure participants have access to the Note Taking Activity Walkthrough Video.
- [ ] Ensure HMW section on Mural is organized. 
- [ ] Ensure participants have access to the HMW Activity Walkthrough video. 

 |  Activity  | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---| 
| Watch Lightning Talks | Async | 15 Minutes Per Talk | Video Recording and Note Taking Tool |  • Participants will watch lightning talks and complete the note-taking activity async. <br/> • The Facilitator will provide an overview video of what is expected during the note taking portion of this activity. |
| How Might We’s (HMWs) | Async | 20 Minutes | Mural | • Participants will take their notes from the Lightning Talk activity and craft some HMWs around the opportunities uncovered. <br/> • The facilitator will provide participants a video to describe the HMW activity and review what makes a good HMW statement. <br/> • The facilitator will also be available to sync on Slack for any questions around the activity. |

#### Post-Day Facilitator Checklist:
- [ ] Answer any questions that come up during the async HMW activity. 
- [ ] Send a sync session reminder in the Slack channel. 

## Day 1 - Sync Session | `Add Date`

#### Pre-Day Facilitator Checklist:
- [ ] Ensure all sync Mural boards are organized (Affinity Mapping, Goals, Hurdles, Squiggle Birds).
- [ ] Ensure sync session is recorded. 

 |  Activity | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---|
| Affinity Mapping | Sync | 30 Minutes | Zoom and Mural | • Participants take turns reading aloud their HMWs. (5 minutes). <br/> • Once the review has completed, the facilitator will choose an Affinity Mapper who will be in charge of categorizing the HMWs with the help of the entire group (10 Minutes). <br/> • Once the HMWs are organized into categories, the group will do a round of dot voting on the categories we want to focus on for the Sprint. Each participant will get three votes, and vote individually on the category they feel is most important to work on (10 Minutes). <br/> • The facilitator will allow time for discussion around the HMW groups chosen, and see if there needs to be adjustments (5 Minutes).  |
| Sprint Goal  | Sync | 20 Minutes | Zoom and Mural | • Based on the outcomes of the HMW activity, participants start by asking themselves the following question: “If everything worked out perfectly, what would that look like for this project?” <br/> • Each participant writes one Sprint goal on a Mural sticky starting with “By the end of the Sprint…” (10 Minutes)  <br/> • Everyone on the team should share their Sprint Goal with the larger group and post them on the Mural (5 Minutes). <br/> • Everyone is given one dot to vote on what they think the Sprint Goal should be. (5 Minutes) |
| Sprint Hurdles | Sync  | 20 Minutes | Zoom and Mural |  • Participants will list out possible critical hurdles, in the form of a question, that may stop you from reaching your goal: What could stop us or heavily impact us from reaching our goals? <br/> • Each question must start with ‘Can we...’ <br/> • Each person can only write 2 questions (10 Minutes)  <br/> • Everyone on the team should share their Hurdles back to the larger group and post them up on the Mural (5 Minutes). <br/> • Everyone is given three to vote on what they think are the most important to focus on as challenges toward the Goal. (5 Minutes)	|
|  Recap of Day | Sync  | 5 Minutes | Zoom and Mural | • Facilitator gives and overview of what has been completed so far during Day 1 of the Sprint and expectations for Day 2 Homework |
| Squiggle Birds | Sync  | 5 Minutes | Zoom, Paper and Pen/Sharpie | • Sync warm-up drawing activity to prep for next async tasks. <br/> • The facilitator will draw a squiggle on Mural and encourage all participants to also make a squiggle. <br/> • Everyone will then turn the squiggle into a bird. <br/> • The facilitator will share that "Our minds are great at recognizing patterns." Sketches are only used to convey an idea, so they don't need to be super detailed or accurate. |

#### Post-Day Facilitator Checklist:
- [ ] Send a Day 1 overview and homework reminder in the Slack channel. 
- [ ] Post-sync session recording in the Slack channel. 
- [ ] Ensure [Day 2 Issue](Add Link) is complete.
- [ ] Ensure participants have access to the Crazy 8s Walkthrough Video.
- [ ] Ensure the Crazy 8s section on Mural is organized. 

## Day 2 - Sprint Homework | (Add Date)

#### Pre-Day Facilitator Checklist:
- [ ] Ensure Ideation recordings are added to the [Day 2 Issue](Add Link). 
- [ ] Ensure participants have access to the Ideation Walkthrough Videos.
- [ ] Ensure the Ideation section on Mural is organized. 

|  Activity | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---|
| Note Recap | Async | Google Docs | 5 Minutes | • Review all the notes that were taken during Day 1. <br/> • Review all the HMW stickies to jog your memory.	 |
| Ideas List | Async | Google Docs | 5 Minutes | • On a piece of paper jot down any solutions that come to mind around solving HMW statements.	 |
| Crazy 8s | Async | Paper and Marker/Pen | 8 Minutes |  •  Grab your printer paper and create an 8-panel page by folding your paper in half 3 times. <br/> • Draw a sketch for an idea in each rectangle. <br/> • Start at the top of your HMW statements/ideas list from the previous activity.|
| Share-out Prep | Async | Mural | 10 Minutes |  •  In preparation for the share-out, take a photo of your Crazy 8 paper and add it to the Mural. |

#### Post-Day Facilitator Checklist:
- [ ] Send a sync session reminder in the Slack channel. 

## Day 2 - Sync Session | `Add Date`

#### Pre-Day Facilitator Checklist:

- [ ] Ensure sync Murals are organized (Crazy 8s, Storyboarding).
- [ ] Ensure sync session is recorded. 

|  Activity | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---|
| Crazy 8's Share out and Voting | Sync | 15 Minutes | Zoom and Mural | • Each person will have two minutes to present their ideas to the team. <br/> • After each team member has gotten the chance to present their ideas, we will do a round of dot voting. <br/> • Vote on the ideas you think will be best to solve our Sprint problem. <br/> • Each team member will get 3 votes. |
| Storyboarding Key Moments | Sync - 2 Groups | 30 Minutes | Zoom, Paper and Sharpie/Pen | • Take the first 10 minutes to write down the 8-10 key moments individually. <br/> • As a team decide on the ideal storyboard together. <br/> • Try and bring out the task that needs to be done and the emotion that you would like the user to experience. <br/> • No drawing yet!	 |
| Storyboard Details | Sync | 20 Minutes | Zoom, Paper and Pen/Sharpie | • Take your draft storyboard and give it more detail. <br/> • DRAW BIG! Sketch 1 key moment per 8.5x11 page. <br/> • Each person on the team should sketch at least 1 key moment. <br/> • Focus on actions and emotions. |
| Put Together the Story | Sync | 10 Minutes | Zoom and Mural | • Each person will take a photo of their storyboard and add it to the Mural. |
| Storyboard Share Out and Voting | Sync | 15 Minutes | Zoom and Mural | •  Each group takes turns presenting their story to the Sprint team. <br/> • Once both teams have had the chance to present their storyboard, we’ll hold a round of voting. <br/> • Each person will be given 3 votes to vote for any part of each experience they like. <br/> • The Decider gets 6 votes for this activity, 3 mega-likes and 3 dislikes. 	 |
| All in One or Rumble | Sync | 5 Minutes | Zoom | •  Decide as a group if you want to incorporate the best parts of both storyboards into one or if you want to test both storyboards against each other during the testing phase. 	 |

#### Post-Day Facilitator Checklist:
- [ ] Send a Day 2 overview and homework reminder in the Slack channel. 
- [ ] Post-sync session recording in the Slack channel. 
- [ ] Ensure [Day 3 Issue](Add Link) is complete.

## Day 3 - Group Sprint Homework | (Add Date)

#### Post-Day Facilitator Checklist:
- [ ] Set up a Figma File for the prototype and ensure it's shared with the group. 

|  Activity | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---|
| Prototyping | Async | 1 Hour | Figma |  • The Designer will craft out a prototype based on the storyboard for the team to review. |
| Prototyping Feedback | Async | 10 Minutes | Figma |  • Once the Designer has completed the prototype, the team will review it and leave feedback. <br/> • There will only be a single round of feedback before hallway testing (where we will receive additional feedback from users). |
| Review Hallway Testing Slides | Async | 10 Minutes | Slides |  • Review the details on what Hallway Testing is to prepare for the next sync session. |

#### Post-Day Facilitator Checklist:
- [ ] Send a sync session reminder in the Slack channel. 

## Day 3 - Sync Session | (Add Date)

#### Pre-Day Facilitator Checklist:

- [ ] Ensure sync Murals are organized (Hallway Testing Prep).
- [ ] Ensure sync session is recorded. 
- [ ] Ensure the prototype is done and has been adjusted from the feedback. 
- [ ] Gathered a few potential Hallway Test Volunteers. 

|  Activity | Type of Activity | Duration | Tool  | Description  |
|---|---|---|---|---|
| Define a Research Objective | Sync | 10 Minutes | Zoom and Mural |  •  As a group, write a research objective for your hallway test. Make sure to capture: What you want to learn, Who you want to talk to, What you plan to do with what you learn. |
| Write a Test Scenario | Sync | 10 Minutes | Zoom and Mural | •  As a group, write a test scenario for your hallway test. <br/> • Write down a list of key tasks that you’d like the participant to complete while using the prototype.	|
| Write Test Questions | Sync | 10 Minutes | Zoom and Mural | •  As a group, write a test scenario for your hallway test. <br/> • Craft a list of questions and / or tasks that you’ll ask participants to answer or complete in order to answer your research objectives.	|
| Hallway Testing | Sync | 50 Minutes | Zoom | •  Working in groups of 2-3, review the discussion guide and prototype. <br/> •  Determine who will ask questions and who will take notes. Remember to switch roles after each test! <br/> • It’s up to you where you take notes. <br/> • Join the Zoom meeting with your assigned person & test your prototype. <br/> • Have the team document what they hear and be prepared to share back with the larger sprint team.	|
| Hallway Testing Share-out | Sync | 20 Minutes | Zoom | • Each group will have roughly 5 minutes to present their findings from Hallway Testing. Each team should present: <br/> • What were the common themes? <br/> • What did you hear that was surprising? <br/> • Any red flags? <br/> • Thank participants for their time. |

#### Post-Day Facilitator Checklist:
- [ ] Summarize themes of Hallway Testing and share with the Slack channel and the [Day 3 Issue](Add Link).
- [ ] Optionally, share with UX, Product, and other relevant Slack channels. 
- [ ] Share with team next steps related to Day 4 and Usertesting. 

## Day 4 - Usertesting | (Add Date)

<!-- Day 4 can happen at a later date when it makes the most sense. Use the problem validation issue template for Day 4.  -->

Day 4 consists of a round of user testing which typically happens a week or more after the first three days complete. 

* **Day Four Issue:** (Day 4 Issue Link)

## Ground Rules
*  Honor the Facilitator's directions. They're the guide for the entire process.
*  Minimise distractions: During the week you will need to dedicate some hours to the Sprint for async tasks and sync video conferences. During this time we recommend blocking time in your calendar and having devices or apps with notifications turned off during that time. 
*  All opinions are valid and are equally important, however, the Decider has the ultimate, final decision.
*  Everyone is an active participant in a sync activity (with the exception of the Observers).
*  One conversation at a time.
*  Document as much as you can: We should have concrete outputs to share with broader team. Also interesting ideas or fixes should be documented to be transferred in issues for our backlog.
*  Stick to scheduled breaks during sync calls. The Facilitator will guide each session and set break times.
*  The Sprint is one of the few chances we get to work so closely together. Have fun!
